﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Domaine;

namespace IHM
{
    /// <summary>
    /// Dialogue de choix de l'emprunt rendu (retourné)
    /// </summary>
    public partial class DlgRetour : Form
    {
        public DlgRetour(List<Emprunt> empruntsARetourner)
        {
            InitializeComponent();

            // Ajout de la liste des emprunts à la liste déroulante
            cbxEmprunt.Items.AddRange(empruntsARetourner.ToArray<Emprunt>());
            if (cbxEmprunt.Items.Count > 0)
            {
                // sélection du 1er élément de la liste
                cbxEmprunt.SelectedIndex = 0;
            }
        }

        /// <summary>
        /// Renvoie l'emprunt rendu
        /// </summary>
        /// <returns></returns>
        public Emprunt GetEmpruntRendu()
        {
            return (Emprunt) cbxEmprunt.SelectedItem;
        }
    }
}
